<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Account extends Model 
{

    protected $table = 'accounts';
    public $timestamps = true;
    protected $fillable = array('last_connection', 'id_customer', 'id_account_kind', 'id_user');
    protected $visible = array('last_connection', 'id_customer', 'id_account_kind', 'id_user');

    public function user()
    {
        return $this->hasOne('User', 'id_user');
    }

    public function accountKind()
    {
        return $this->hasOne('AccountKind', 'id_account_kind');
    }

    public function customer()
    {
        return $this->hasOne('Customer', 'id_customer');
    }

}